<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-plus-circle me-2"></i>Tambah Riwayat Pendidikan
    </h2>
    <a href="<?= base_url('admin/education') ?>" class="btn btn-secondary">
        <i class="bi bi-arrow-left me-1"></i>Kembali
    </a>
</div>

<?php if (session()->getFlashdata('errors')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            <?php foreach (session()->getFlashdata('errors') as $error): ?>
                <li><?= $error ?></li>
            <?php endforeach; ?>
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="admin-card">
    <form action="<?= base_url('admin/education/store') ?>" method="POST" enctype="multipart/form-data">
        <?= csrf_field() ?>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="jenjang" class="form-label">Jenjang <span class="text-danger">*</span></label>
                <select class="form-select" id="jenjang" name="jenjang" required>
                    <option value="">Pilih Jenjang</option>
                    <option value="SD" <?= old('jenjang') === 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= old('jenjang') === 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= old('jenjang') === 'SMA' ? 'selected' : '' ?>>SMA</option>
                    <option value="SMK" <?= old('jenjang') === 'SMK' ? 'selected' : '' ?>>SMK</option>
                    <option value="D3" <?= old('jenjang') === 'D3' ? 'selected' : '' ?>>D3 (Diploma)</option>
                    <option value="S1" <?= old('jenjang') === 'S1' ? 'selected' : '' ?>>S1 (Sarjana)</option>
                    <option value="S2" <?= old('jenjang') === 'S2' ? 'selected' : '' ?>>S2 (Magister)</option>
                    <option value="S3" <?= old('jenjang') === 'S3' ? 'selected' : '' ?>>S3 (Doktor)</option>
                </select>
            </div>
            <div class="col-md-6 mb-3">
                <label for="urutan" class="form-label">
                    <i class="bi bi-sort-numeric-up me-1"></i>Urutan Tampil
                </label>
                <input type="number" class="form-control" id="urutan" name="urutan" 
                       value="<?= old('urutan', 0) ?>" min="0" max="100">
                <div class="form-text">
                    <i class="bi bi-info-circle me-1"></i>
                    <strong>Urutan untuk menampilkan data:</strong><br>
                    • 0 = Tampil paling atas/pertama<br>
                    • 1, 2, 3... = Urutan selanjutnya<br>
                    • Semakin kecil angka, semakin atas posisinya
                </div>
            </div>
        </div>

        <div class="mb-3">
            <label for="nama_sekolah" class="form-label">Nama Sekolah/Universitas <span class="text-danger">*</span></label>
            <input type="text" class="form-control" id="nama_sekolah" name="nama_sekolah" 
                   value="<?= old('nama_sekolah') ?>" required>
        </div>

        <div class="mb-3">
            <label for="jurusan" class="form-label">Jurusan</label>
            <input type="text" class="form-control" id="jurusan" name="jurusan" 
                   value="<?= old('jurusan') ?>" placeholder="Contoh: Teknik Informatika">
        </div>

        <div class="row">
            <div class="col-md-3 mb-3">
                <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
                <input type="number" class="form-control" id="tahun_mulai" name="tahun_mulai" 
                       value="<?= old('tahun_mulai') ?>" min="1900" max="2100" placeholder="Contoh: 2015">
            </div>
            <div class="col-md-3 mb-3">
                <label for="status_pendidikan" class="form-label">Status</label>
                <select class="form-select" id="status_pendidikan" name="status_pendidikan" onchange="toggleTahunSelesai()">
                    <option value="lulus" <?= old('status_pendidikan', 'lulus') === 'lulus' ? 'selected' : '' ?>>Lulus</option>
                    <option value="sedang_menempuh" <?= old('status_pendidikan') === 'sedang_menempuh' ? 'selected' : '' ?>>Sedang Menempuh</option>
                    <option value="tidak_lulus" <?= old('status_pendidikan') === 'tidak_lulus' ? 'selected' : '' ?>>Tidak Lulus</option>
                    <option value="cuti" <?= old('status_pendidikan') === 'cuti' ? 'selected' : '' ?>>Cuti</option>
                    <option value="pindah" <?= old('status_pendidikan') === 'pindah' ? 'selected' : '' ?>>Pindah</option>
                </select>
            </div>
            <div class="col-md-3 mb-3" id="tahun_selesai_container">
                <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
                <input type="number" class="form-control" id="tahun_selesai" name="tahun_selesai" 
                       value="<?= old('tahun_selesai') ?>" min="1900" max="2100" placeholder="Contoh: 2019">
                <small class="text-white">Kosongkan jika sedang menempuh</small>
            </div>
            <div class="col-md-3 mb-3">
                <label for="nilai_akhir" class="form-label">Nilai Akhir</label>
                <input type="number" step="0.01" class="form-control" id="nilai_akhir" name="nilai_akhir" 
                       value="<?= old('nilai_akhir') ?>" placeholder="Contoh: 3.75 atau 90.5">
                <small class="text-white">IPK/Rata-rata nilai</small>
            </div>
        </div>

        <div class="mb-3">
            <label for="deskripsi" class="form-label">
                <i class="bi bi-file-text me-1"></i>Deskripsi
            </label>
            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" 
                      placeholder="Masukkan deskripsi pendidikan..."><?= old('deskripsi') ?></textarea>
            <div class="form-text">
                <i class="bi bi-info-circle me-1"></i>
                Deskripsikan pengalaman atau pencapaian selama menempuh pendidikan ini.
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save me-1"></i>Simpan
            </button>
            <a href="<?= base_url('admin/education') ?>" class="btn btn-secondary">
                <i class="bi bi-x me-1"></i>Batal
            </a>
        </div>
    </form>
</div>
<?= $this->endSection() ?>

<script>
function toggleTahunSelesai() {
    const status = document.getElementById('status_pendidikan').value;
    const tahunSelesaiContainer = document.getElementById('tahun_selesai_container');
    const tahunSelesaiInput = document.getElementById('tahun_selesai');
    
    if (status === 'sedang_menempuh') {
        tahunSelesaiContainer.style.opacity = '0.5';
        tahunSelesaiInput.disabled = true;
        tahunSelesaiInput.value = '';
        tahunSelesaiInput.placeholder = 'Tidak diperlukan (sedang menempuh)';
    } else {
        tahunSelesaiContainer.style.opacity = '1';
        tahunSelesaiInput.disabled = false;
        tahunSelesaiInput.placeholder = 'Contoh: 2019';
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleTahunSelesai();
});
</script>
